### Android ZPL SDK Manual

#### 1 SDK Load and Use

##### 1.1 Load

- Copy the jar package to the app/libs folder

- Add the following code to the build.gradle in the app

  ```java
  android{
    sourceSets {
          main {
              jniLibs.srcDirs = ['libs']
          }
      }
  }
  implementation  files('libs/ZPL_SDK_V1.01.jar')
  implementation 'com.github.barteksc:pdfium-android:1.9.0'//SDK required 
  ```



##### 1.2 Use

- The interfaces we use are in the ZPLPrinterHelper class.

  ```java
  ZPLPrinterHelper mZPL = ZPLPrinterHelper.getZPL(mContext)
  mContext：context object.
  ```

  

#### 2 SDK Connecting Method

##### 2.1 Bluetooth Connection	

- describe

  ```java
  int PortOpen(String portSetting)
  ```

- Parameter

  ```java
  portSetting：”Bluetooth,”+MAC（MAC: Bluetooth address）
  ```

- Return

  ```java
  0: connection success.  -1: connection failure.
  ```

  

##### 2.2 WIFI Connection	

- describe

  ```java
  int PortOpen(String portSetting)
  ```

- Parameter

  ```java
  portSetting：“WiFi,”+IP+”,”+PortNumber
  IP：Printer IP address.
  PortNumber：port. Default: 9100
  ```

- Return

  ```java
  0: connection success.  -1: connection failure.
  ```

  

##### 2.3 USB Connection	

- describe

  ```java
  int PortOpen(UsbDevice usbdevice)
  ```

- Parameter

  ```java
  usbdevice：UsbDevice object.
  ```

- Return

  ```java
  0: connection success.  -1: connection failure.
  ```

  

##### 2.4 Disconnect	

- describe

  ```java
  boolean PorClose()
  ```

- Parameter

  ```java
  null
  ```

- Return

  ```java
  true：disconnect succeed，false：disconnect fail。
  ```

  

#### 3 SDK Print Command

##### 3.1 Label Start

- describe

  ```java
  int start()
  ```

- Parameter

  ```java
  null
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.2 set Coordinates

- describe

  ```java
  int setXY(String x,String y)
  ```

- Parameter

  ```java
  X：x-axis.
  Y：y-axis.
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

  

##### 3.3 Label End

- describe

  ```java
  int end()
  ```

- Parameter

  ```java
  null
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.4 Field Data Start

- describe

  ```java
  int FD(String fd)
  ```

- Parameter

  ```java
  fd：Text.
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.FD(“TEXT”);
  mZPL.FS();
  mZPL.end();
  ```

  

##### 3.5 Field Data End

- describe

  ```java
  int FS()
  ```

- Parameter

  ```java
  null
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.FD(“TEXT”);
  mZPL.FS();
  mZPL.end();
  ```

  

##### 3.6 Print Width

- describe

  ```java
  int PW(String pw)
  ```

- Parameter

  ```java
  pw：width (in dots).
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.PW(“100”)
  mZPL.setXY(“0”,”0”);
  mZPL.FD(“TEXT”);
  mZPL.FS();
  mZPL.end();
  ```

  

##### 3.7 Direction and Justification

- describe

  ```java
  int FW(String rotate,String justification)
  ```

- Parameter

  ```
  rotate：rint direction, value is as below:
  	N = normal
  	R = rotated 90 degrees
  	I = inverted 180 degrees
  	B = bottom-up 270 degrees, read from bottom up
  Justification：ustification method, value is as below:
  	0 = left justification
  	1 = right justification
  	2 = auto justification (script dependent)
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.FW(“N”,”0”)
  mZPL.setXY(“0”,”0”);
  mZPL.FD(“TEXT”);
  mZPL.FS();
  mZPL.end();
  ```

  

##### 3.8 Print Line

- describe

  ```java
  int printLine(String w,String h,String t,String c,String r)
  ```

- Parameter

  ```
  w: width of line (1~32000 unit: dot)
  H: height of line (1~32000 unit: dot)
  T: thickness of line (1~32000 unit: dot)
  C: color of line:
  	B=black; (Default:B)
  	W=white；
  R: radian of rounded corner(0~8)
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.printLine(“100”,”2”,”2”,”B”,”0”)//Print the horizontal line with 100-dot width and 2-dot height
  mZPL.end();
  ```

  

##### 3.9 Print Circle

- describe

  ```java
  int printCircle(String d,String t,String c)
  ```

- Parameter

  ```
  d: diameter of circle (3~4095).
  t: thickness of circle border (1~4095).
  C: color of circle:
  	B=black；(Default:B)
  	W=white；
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.printCircle(“100”,”2”,”B”)
  mZPL.end();
  ```

  

##### 3.10 Print Slash Line

- describe

  ```java
  int printSlashLine(String w,String h,String t,String c,String o)
  ```

- Parameter

  ```
  w: width of slash line (3~32000).
  H: height of slash line (3~32000).
  T: thickness of slash line (1~32000).
  C: color of slash line:(Default:B)
  	B=black；
  	W=white；
  O：direction of slash line:(Default:R)
  	R (or /) = right-leaning diagonal
  	L (or \) = left-leaning diagonal
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.printSlashLine(“100”,”100”,”2”,”B”,”R”)
  mZPL.end();
  ```

  

##### 3.11 Set  Label Home Position

- describe

  ```java
  int LH(String x,String y)
  ```

- Parameter

  ```
  X: x-axis of home position
  Y: y-axis of home position
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

  

##### 3.12 Label Shift

- describe

  ```java
  int LS(String ls)
  ```

- Parameter

  ```
  ls：shift value (-9999~9999) negative indicates right shift, (Default:0).
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.LS(“20”)
  mZPL.printText(“100”,”100”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.13 Text Blocks 

- describe:has an automatic word-wrap function

  ```java
  int TB(String a,String b,String c)
  ```

- Parameter

  ```
  a: block rotation:
    N = normal
    R = rotate 90 degrees clockwise
    I = invert 180 degrees
    B = read from bottom up-270 degrees
  b: block width in dots
  c: block height in dots
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.TB(“N”,”300”,”300”)
  mZPL.printText(“100”,”100”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.14 QR Code

- describe

  ```java
  int printQRcode(String x,String y,String orientation,
                  String magnification,String size,String data)
  ```

- Parameter

  ```
  x: x-axis
  y: y-axis
  orientation: (N).
  magnification:Default(2)
  	1= Normal mode
  	2= Enhanced mode
  size: size (1~10).
  data: content of 2D code
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printData("^CI14\r\n");
  mZPL.printQRcode(“10”,”10”,”N”,”2”,”5”,”abc123”);
  mZPL.end();
  ```

  

##### 3.15 Bar Code

- describe

  ```java
  int printBarcode(String x,String y,int type,
                   String orientation,String height,String f,String data)
  ```

- Parameter

  ```
  x: x-axis
  y: y-axis
  Bar code type:
  	0=39
  	1=EAN-8
  	2=UPC-E
  	3=93
  	4=128
  	5=EAN-13
  Orientation:
    N = normal
    R = rotated 90 degrees (clockwise)
    I = inverted 180 degrees
    B = read from bottom up, 270 degrees
  Height: height of bar code (1-32000).
  F: whether the content of bar code is visible (Default Y):
    Y = yes
    N = no
  data: content of bar code
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printBarcode(“10”,”10”,”0”,”N”,”100”,”Y”,”123456789”);
  mZPL.end();
  ```

  

##### 3.16 Print Bitmap

- describe

  ```java
  void printBitmap(String x, String y, int halftoneType, Bitmap bmp)
  ```

- Parameter

  ```
  x: starting x-axis
  y: starting y-axis
  halftoneType：Image Algorithm
  	0：Binary (black and white)
  	1：jitter
  bmp：bitmap object.
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printBitmap(“10”,”10”,0,bitmap);
  mZPL.end();
  ```

  

##### 3.17 Write Data

- describe

  ```java
  int WriteData(byte[] bData)
  ```

- Parameter

  ```
  bData: the data which needs to be sent to the printer
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.WriteData(byt)
  ```

  

##### 3.18 Read Data

- describe

  ```java
  byte[] ReadData(int outTime)
  ```

- Parameter

  ```
  outTime: time of outTime (Unit: second)
  ```

- Return

  ```java
  The read data
  ```

- Example

  ```java
  mZPL.ReadData(2)
  ```

  

##### 3.19 Self Test Page

- describe

  ```java
  int selfTest()
  ```

- Parameter

  ```
  null
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.selfTest()
  ```

  

##### 3.20 Print Text

- describe：You need to select a code when printing Chinese, please refer to the example.

  ```java
  int printText(String x,String y,int type,String orientation,int size,String data)
  ```

- Parameter

  ```
  x: x-coordinate
  y: y-coordinate
  type: font (0~6: ineffective for Chinese,7:Chinese)
  orientation：
    N = normal
    R = rotate 90 degrees clockwise
    I = invert 180 degrees
    B = read from bottom up-270 degrees
  size: font size
    1: 10px
    2: 20px
    3: 30px
    4: 40px
    5: 50px
    6: 60px
  data: text data
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printData("^CI14\r\n")//This sentence needs to be added when printing Chinese
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.21 Print Quantity and Cutter

- describe：

  ```java
  int PQ(String q,String p,String r,String o)
  ```

- Parameter

  ```
  q:print quantity
  p:Number before suspension or before cutting knife
  r:Number of copies of each serial number
  o:Cut or pause
    Y:cutter
    N:pause
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printData("^CI14\r\n")
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.PQ(1,1,1,Y);//Print one piece and then cut the knife
  mZPL.end();
  ```

  

##### 3.22 Printer Model

- describe：

  ```java
  int setPrinterModel(String model)
  ```

- Parameter

  ```
  model：
  	T = Tear.
  	P = Peel （Not supported on some machines）.
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printData("^CI14\r\n")
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.setPrinterModel(“P”);//Switch to peel mode
  mZPL.end();
  ```

  

##### 3.23 Write RFID

- describe：

  ```java
  int writeRFID(int address, int memory,byte[] data)
  ```

- Parameter

  ```
  address：starting address
  	range: greater than 0 EPC address must start at 2.
  memory：write area
  	0 = Preserved
  	1 = EPC 
  	3 = User
  data：需写入的数据。（保留区，EPC不超过12个字节，User不超过128）
  ```

- Return

  ```java
  -1：send failed，-2：parameter error，0：write successful.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.writeRFID(0,1,"Test RFID".getBytes());
  mZPL.end();
  ```

  

##### 3.24 Read RFID

- describe：

  ```java
  byte[] readRFID(int address,int length,int memory)
  ```

- Parameter

  ```
  address：starting address.
  	range: greater than 0 EPC address must start at 2.
  length：The length of the read. Preserved\EPC no more than 12 bytes, User no 				more than 128
  memory：Write area 
  	0 = Preserved
  	1 = EPC 
  	3 = User
  ```

- Return

  ```java
  Readable data, empty means read failed.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.writeRFID(2,1,"中文".getBytes("GB2312"));
  mZPL.readRFID(2, 4, 1);
  mZPL.end();
  byte[] bytes = mZPL.ReadData(3);
  if (bytes!=null&&bytes.length>0){
    String hexStr = new String(bytes);
    byte[] hexByte = UtilityTooth.hexToByte(hexStr);
  	Toast.makeText(thisCon,newString(hexByte,"GB2312"),Toast.LENGTH_SHORT).show();
  }
  ```

  

##### 3.25 Read SN

- describe：

  ```java
  String getPrinterSN()
  ```

- Parameter

  ```
  null
  ```

- Return

  ```java
  SERIAL NEMBER:SN.
  ```

- Example

  ```java
  mZPL.getPrinterSN();
  ```

  

##### 3.26 PDF to Bitmap

- describe：

  ```java
  List<Bitmap> pdfToBitmap(Context context, File file, String pageNumber, int pageWidth)
  ```

- Parameter

  ```
  context：context object.
  file：PDF file.
  pageNumber：page number（"1,3-7"）。
  pageWidth：bitmap width.
  ```

- Return

  ```java
  List<Bitmap>：bitmap.
  ```

- Example

  ```java
  List<Bitmap> bitmaps = mZPL.pdfToBitmap(thisCon, file, "1", 576);
  ```

  

